
-- FUNCTION: public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_conv(
	integer,
	integer,
	integer,
	integer,
	integer,
	integer,
	integer)
    RETURNS SETOF rs_tab_desc_prod_conv 
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$
 --<<INICIO DO CORPO DA FUNCAO
-- Function: select * from ufd_est_prod_tbl_desc_conv(1, 2, 3, 101, 1 , 0)
/*  
 EMPRESA: VETOR SOLUCOES
 FUNO:  ufd_est_prod_tbl_desc_conv
 OBJETIVO: RETORNAR DESCONTOS DO PRODUTO EM TABELA DE DESCONTO
 AUTOR:  FERNANDO JUNIO CUNHA E SOUSA  
 CRIACAO: 06/2012  
 COMENTS: ALTERADA EM 12/2012 PARA ACRESCENTAR O CONTROLE DA FLAG_SOMENTE_DESC_CONTRATO NO CADASTRO CONVENIO
			 EDITADA POR: FERNANDO JUNIO CUNHA E SOUSA 
 int_cd_emp          --- CODIGO DA EMPRESA  
 int_cd_filial       --- CODIGO DA FILIAL  
 int_cd_prod         --- CODIGO DO PRODUTO  
 int_cd_cli          --- CODIGO DO CLIENTE PARA RETORNO DE DESCONTO PARA CLIENTE 
 int_cd_conv         --- CODIGO DO CONVENIO ( CASO SEJA CONVENIADO,SE NAO FOR DEVE-SE PASSAR ZERO)  
 int_is_receita     --- INDICA SE E VENDA COM RECEITA OU NÃO
*/ 
--DECLARA AS VARIAVEIS USADAS NA FUNCAO
DECLARE
---------------------------------------------------------
----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
int_cd_emp              ALIAS FOR $1;
int_cd_filial           ALIAS FOR $2; 
int_cd_prod             ALIAS FOR $3;
int_cd_cli             	ALIAS FOR $4;
int_cd_conv	            ALIAS FOR $5;
int_is_receita          ALIAS FOR $6;
int_libera_vd_conv      ALIAS FOR $7;
---------------------------------------------------------
---FIM
---------------------------------------------------------
returnRec rs_tab_desc_prod_conv; --RECEBERA OS DADOS DE RETORNO DA FUNCAO
--DECLARANDO VARIAVEL PARA TESTE DA FLAG 
vr_cd_plano_venda                   integer;
vr_qtde_prod_max_conv               integer;
vr_qtde_prod_max_conv_by_prod       integer;
vr_libera_vd_conv                   integer;
vr_procedure_desc_extra             character varying(250);
/*vr_cd_tbl_desc                      integer;
vr_tp_desc                          integer;
vr_flag_desc_fix                    integer;
vr_perc_desc                        double precision;
vr_perc_desc_max                    double precision;
vr_tp_nivel                         integer;
vr_exclue_oferta                    integer;
*/
BEGIN --INICIO DOS BLOCOS DA FUNCAO
	-- SETANDO VALORES INICIAIS
	vr_cd_plano_venda             = 0;
	vr_qtde_prod_max_conv         = -1;
	vr_qtde_prod_max_conv_by_prod = -1;
	vr_procedure_desc_extra       = '';
	vr_libera_vd_conv             = int_libera_vd_conv;
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE temp_tab_desc_prod_conv
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone,
			libera_vd_conv      integer,
			exclue_oferta       integer,
			qt_max              integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_tab_desc_prod_conv; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA QUE RECEBERA AS TBLS VIGENTES
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_tab_ativa_conv
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_tab_ativa_conv; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_est_prod_arv_merc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------FIM DA CRIACAO DAS TBLS TEMPORARIAS-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	IF int_cd_conv > 0 THEN
		-------------------------------------------------------------------------------------------------------------------------------
		--BUSCANDO ARVORE MERC. DO PRODUTO
		-------------------------------------------------------------------------------------------------------------------------------	
		INSERT INTO rs_est_prod_arv_merc		
			SELECT 
				arv.cd_emp					,
				arv.cd_prod					,
				arv.cd_arv_merc_categ		,
				arv.cd_arv_merc_linha		,
				arv.cd_mc					,
				arv.cd_arv_merc_familia		,												
				p.cd_fabric 
			FROM 	est_prod_est_arv_mercadologica arv INNER JOIN est_prod p ON
					arv.cd_emp		= p.cd_emp
					AND arv.cd_prod = p.cd_prod
			WHERE   	arv.cd_emp = int_cd_emp
				AND 	arv.cd_prod = int_cd_prod;
		--raise notice 'cd_arv_merc_linha %', (select cd_arv_merc_linha from rs_est_prod_arv_merc limit 1);
	
			
	IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) then
		
		-- CAPTURANDO PLANO DE VENDA
			vr_cd_plano_venda = COALESCE((SELECT
											    COALESCE(rc_cli_conv_rc_cli.cd_plano_venda,0)
									  	    from rc_cli_conv_rc_cli 	
										   where int_cd_emp  = rc_cli_conv_rc_cli.cd_emp 
										     AND int_cd_cli  = rc_cli_conv_rc_cli.cd_cli
										     and int_cd_conv = rc_cli_conv_rc_cli.cd_conv
										   ),0);
										  
			-- TODAS AS TABELAS QUE NAO EXITE RECEITA
			INSERT INTO rs_tab_ativa_conv    
				SELECT  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				FROM	est_prod_tbl_desc a INNER JOIN 
				        est_prod_tbl_desc_prc_filial fil ON    
							a.cd_emp = fil.cd_emp AND    
							a.cd_tbl_desc = fil.cd_tbl_desc INNER JOIN
						rc_cli_conv_est_prod_tbl_desc conv ON     
							a.cd_emp = conv.cd_emp AND 
							a.cd_tbl_desc = conv.cd_tbl_desc AND 
							int_cd_conv = conv.cd_conv AND 
							vr_cd_plano_venda = conv.cd_plano_venda  
				WHERE	int_cd_emp = a.cd_emp AND     
                        int_cd_filial = fil.cd_filial AND		
						CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
						1 = a.sts_tbl_desc AND    
						3 = a.cd_tp_desconto AND 
						a.flag_desc_receita = 0;
			-- INCLUI AS TABELAS QUE EXITE RECEITA			
			IF 	int_is_receita > 0 THEN		
				INSERT INTO rs_tab_ativa_conv    
					SELECT  a.cd_emp,    
							a.cd_tbl_desc,    
							a.cd_tp_desconto
					FROM est_prod_tbl_desc a INNER JOIN 
					     est_prod_tbl_desc_prc_filial fil ON    
							a.cd_emp = fil.cd_emp AND    
							a.cd_tbl_desc = fil.cd_tbl_desc INNER JOIN
					     rc_cli_conv_est_prod_tbl_desc conv ON     
							a.cd_emp = conv.cd_emp AND 
							a.cd_tbl_desc = conv.cd_tbl_desc AND 
							int_cd_conv = conv.cd_conv AND 
							vr_cd_plano_venda = conv.cd_plano_venda    
					WHERE	int_cd_emp = a.cd_emp AND   
                            int_cd_filial = fil.cd_filial AND	
							CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
							1 = a.sts_tbl_desc AND    
							3 = a.cd_tp_desconto AND 
							a.flag_desc_receita = 1;
			END IF;
			IF EXISTS (SELECT 1 FROM rs_tab_ativa_conv) THEN
			-------------------------------------------------------------------------------------------------------------------------------
				-- CAPTURA DE QUANTIDADE DE PRODUTO
				-------------------------------------------------------------------------------------------------------------------------------
				vr_qtde_prod_max_conv = COALESCE((SELECT COALESCE(valor, '-1')::integer FROM prc_emp_config WHERE cd_emp = 1 AND cd_chave ILIKE 'CONVENIO_LIMITE_PRODUTOS'), '-1')::integer;
				vr_qtde_prod_max_conv_by_prod = COALESCE((SELECT COALESCE(qtde_prod, -1) FROM rc_cli_conv_est_prod_conv_limite WHERE int_cd_conv = cd_conv AND int_cd_prod = cd_prod ),-1);
				IF vr_qtde_prod_max_conv_by_prod > -1 THEN
					vr_qtde_prod_max_conv = vr_qtde_prod_max_conv_by_prod;		
				END IF; 
				-- FIM CAPTURA DE QUANTIDADE DE PRODUTO
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					  SELECT    
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,    
							1 AS tp_nivel,
							a.dt_ini    
					  FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_tab_ativa_conv ON    
								b.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc     
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_prod = arv.cd_prod           
					  WHERE     
								int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							2 AS tp_nivel,
							a.dt_ini    
					FROM Est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_familia b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
							INNER JOIN rs_tab_ativa_conv ON    
								a.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------        
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					SELECT
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							3 AS tp_nivel,
							a.dt_ini    
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_mc b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_mc = arv.cd_mc    
							INNER JOIN rs_tab_ativa_conv ON    
								a.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							4 AS tp_nivel,
							a.dt_ini     
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod_fabric b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_fabric = arv.cd_fabric     
							INNER JOIN rs_tab_ativa_conv ON    
								b.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
				------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS         
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							5 AS tp_nivel,
							a.dt_ini  
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_categoria b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
							INNER JOIN rs_tab_ativa_conv ON    
								a.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_conv     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc AS perc_desc,    
							b.perc_desc_max AS perc_desc_max,   
							6 AS tp_nivel,
							a.dt_ini 
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_linha b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc arv ON    
								b.cd_emp = arv.cd_emp AND       
								b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
							INNER JOIN rs_tab_ativa_conv ON    
								a.cd_emp = rs_tab_ativa_conv.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					WHERE     
							int_cd_filial = fil.cd_filial;
				-- VALIDANDO BLOQUEIO DE VENDA EM FILIAL
				IF EXISTS ( SELECT cd_filial FROM rc_cli_conv_prc_filial_blq WHERE	cd_emp =int_cd_emp AND cd_filial = int_cd_filial AND cd_conv = int_cd_conv ) THEN
					vr_libera_vd_conv = 0;
				END IF;	--IF EXISTS ( SELECT cd_filial FROM rc_cli_conv_prc_filial_blq ...
				UPDATE 
					temp_tab_desc_prod_conv SET 
						libera_vd_conv = vr_libera_vd_conv ,
						exclue_oferta  = 0 ,
						qt_max         = vr_qtde_prod_max_conv;
				vr_procedure_desc_extra =  COALESCE((
												SELECT 
														COALESCE(a.procedure_desconto, 'N') AS procedure_desconto
												FROM  	rc_cli_conv AS a
												WHERE  	a.cd_emp = int_cd_emp AND 
														a.cd_conv = int_cd_conv
											), 'N');
				--raise notice 'vr_procedure_desc_extra %', vr_procedure_desc_extra;											
				IF vr_procedure_desc_extra <> 'N' THEN
					IF EXISTS (select 1 from pg_proc where proname = vr_procedure_desc_extra) THEN
						EXECUTE 'SELECT cd_tbl_desc ,tp_desc ,flag_desc_fix ,perc_desc ,perc_desc_max ,tp_nivel ,libera_vd_conv ,exclue_oferta ,qt_max FROM ' || vr_procedure_desc_extra || '( $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11 )' 
						   INTO returnRec
						   USING int_cd_emp,
								 int_cd_filial,
								 int_cd_prod,
								 int_cd_cli,
								 int_cd_conv,
								 vr_cd_plano_venda,
								 int_is_receita,							 
								 vr_libera_vd_conv,
								 vr_qtde_prod_max_conv,
								 (select perc_desc      from temp_tab_desc_prod_conv),
								 (select exclue_oferta  from temp_tab_desc_prod_conv);
						RETURN NEXT returnRec;
					END IF;
				END IF; --IF vr_procedure_desc_extra <> 'N' THEN
			END IF;	--IF EXISTS (SELECT 1 FROM rs_tab_qtde_ativa) THEN	
		END IF; --IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) THEN
	END IF; --IF int_cd_conv > 0 THEN
	-------------------------------------------------------------------------------------------------------------------------------
	-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
	-------------------------------------------------------------------------------------------------------------------------------
	FOR returnRec IN 
		SELECT 
			cd_tbl_desc, 
			tp_desc, 
			flag_desc_fix, 
			perc_desc, 
			case when perc_desc_max=0 and perc_desc > perc_desc_max then
											perc_desc else perc_desc_max  end  as perc_desc_max, tp_nivel, libera_vd_conv, exclue_oferta, qt_max 
		  FROM temp_tab_desc_prod_conv 
		 --ORDER BY tp_nivel ASC, perc_desc DESC, dt_ini DESC LIMIT 1
		 ORDER BY dt_ini DESC,tp_nivel ASC, perc_desc DESC  LIMIT 1
	LOOP
		RETURN NEXT returnRec;
	END LOOP;				
END; --FIM DOS BLOCOS DA FUNCAO

$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer)
    OWNER TO postgres;

